% Approximation of asymptotic variance
% Small-scale NK model
clear all;
tic
load('sampledataT464');
% load('v_c1');
% load('v_c2');
rng('default')
rng('shuffle')
% sampledata=sampledataT232;
sampledata=sampledataT464(:,:,:);
[d, T, s] = size(sampledata);
ST = ceil(0.75*(T^(1/3)));

global p h
p=2;
h=80;
hs=1;
N=199;
B=1000;

% theta_hat = 0.745; % etimated alpha value for 1st in sampledataT232
theta_hat = 0.735; % sample #10 of T464
true_theta = 0.75;
step = 0.005;
pair1 = [theta_hat+step theta_hat-step true_theta+step true_theta-step];
% pair2 = [true_theta+step true_theta-step];
pair1_irf = zeros(4*(h+1),4);
% pair2_irf = zeros(4*(h+1),2);
% c1 = mean(v_c1); % tuning c for diagonal operator
% c2 = mean(v_c2); % tuning c for optimal operator
c1=0.4166;
c2=0.4175;
pick_reg_a_1 = c1/(T^(1/3));
pick_reg_a_2 = c2/(T^(1/3));

save_V_thetahat_1 = zeros(B,1);
save_V_thetahat_2 = zeros(B,1);
save_V_thetahat_opt_1 = zeros(B,1);
save_V_thetahat_opt_2 = zeros(B,1);
save_V_theta0_1 = zeros(B,1);
save_V_theta0_2 = zeros(B,1);
save_V_theta0_opt_1 = zeros(B,1);
save_V_theta0_opt_2 = zeros(B,1);

% true IRFs from observations
v_sampledata_full = sampledata(:, :, 10); 

for ii = 1:B
ii
[Af,SIGMAf,Uf,Vf] = olsvarc(v_sampledata_full', p);
sampleirf_full = vec(irfvar(Af,SIGMAf,p));

irf_star_full = zeros(4, (h+1), N);
irf_star_full_1a = zeros(4, (h+1), N);
irf_star_full_1b = zeros(4, (h+1), N);
irf_star_full_2a = zeros(4, (h+1), N);
irf_star_full_2b = zeros(4, (h+1), N);
irf_star_full_3a = zeros(4, (h+1), N);
irf_star_full_3b = zeros(4, (h+1), N);
irf_star_full_4a = zeros(4, (h+1), N);
irf_star_full_4b = zeros(4, (h+1), N);
irf_star_full_5a = zeros(4, (h+1), N);
irf_star_full_5b = zeros(4, (h+1), N);
irf_star_full_6a = zeros(4, (h+1), N);
irf_star_full_6b = zeros(4, (h+1), N);
v_irf_star_full = zeros(4*(h+1), N);
    
for n = 1:N
%         [IRFfull]=bootirf(Af,Uf,v_sampledata_full',Vf);
    [IRFfull IRFfull_ST]=bootirf_opt(Af,Uf,v_sampledata_full',Vf,ST);
    irf_star_full(:, :, n) = IRFfull;% store the values
    irf_star_full_1a(:,:,n) = IRFfull_ST(:,:,1);
    irf_star_full_1b(:,:,n) = IRFfull_ST(:,:,2);
    irf_star_full_2a(:,:,n) = IRFfull_ST(:,:,3);
    irf_star_full_2b(:,:,n) = IRFfull_ST(:,:,4);
    irf_star_full_3a(:,:,n) = IRFfull_ST(:,:,5);
    irf_star_full_3b(:,:,n) = IRFfull_ST(:,:,6);
    irf_star_full_4a(:,:,n) = IRFfull_ST(:,:,7);
    irf_star_full_4b(:,:,n) = IRFfull_ST(:,:,8);
    irf_star_full_5a(:,:,n) = IRFfull_ST(:,:,9);
    irf_star_full_5b(:,:,n) = IRFfull_ST(:,:,10);
    irf_star_full_6a(:,:,n) = IRFfull_ST(:,:,11);
    irf_star_full_6b(:,:,n) = IRFfull_ST(:,:,12);
        
    v_irf_star_full(:, n) = vec(IRFfull);
end

mean_irf_star_full = mean(v_irf_star_full, 2); % calculate the mean of irf from N paths
demean_irf_star_full = irf_star_full-mean(irf_star_full,3);

demean_irf_star_full_1a = irf_star_full_1a-mean(irf_star_full_1a,3);
demean_irf_star_full_1b = irf_star_full_1b-mean(irf_star_full_1b,3);
demean_irf_star_full_2a = irf_star_full_2a-mean(irf_star_full_2a,3);
demean_irf_star_full_2b = irf_star_full_2b-mean(irf_star_full_2b,3);
demean_irf_star_full_3a = irf_star_full_3a-mean(irf_star_full_3a,3);
demean_irf_star_full_3b = irf_star_full_3b-mean(irf_star_full_3b,3);
demean_irf_star_full_4a = irf_star_full_4a-mean(irf_star_full_4a,3);
demean_irf_star_full_4b = irf_star_full_4b-mean(irf_star_full_4b,3);
demean_irf_star_full_5a = irf_star_full_5a-mean(irf_star_full_5a,3);
demean_irf_star_full_5b = irf_star_full_5b-mean(irf_star_full_5b,3);
demean_irf_star_full_6a = irf_star_full_6a-mean(irf_star_full_6a,3);
demean_irf_star_full_6b = irf_star_full_6b-mean(irf_star_full_6b,3);
    
Cf = zeros(N, N);
Cf_opt = zeros(N, N);    
for b = 1:N
    for bprime = 1:N
        Cbb_f = 0;
        Cbb_f_opt = 0;
        for ss = hs: h
            Cbb_f = Cbb_f + demean_irf_star_full(:, ss+1, b)'...
                    * demean_irf_star_full(:, ss+1, bprime)/N;
            Cbb_f_opt = Cbb_f_opt...
                + (demean_irf_star_full(:, ss+1, b)'* demean_irf_star_full(:, ss+1, bprime)...
                + 2*((1-1/ST)*demean_irf_star_full_1a(:,ss+1,b)'*demean_irf_star_full_1b(:,ss+1,bprime)...
                +(1-2/ST)*demean_irf_star_full_2a(:,ss+1,b)'*demean_irf_star_full_2b(:,ss+1,bprime)...
                +(1-3/ST)*demean_irf_star_full_3a(:,ss+1,b)'*demean_irf_star_full_3b(:,ss+1,bprime)...
                +(1-4/ST)*demean_irf_star_full_4a(:,ss+1,b)'*demean_irf_star_full_4b(:,ss+1,bprime)...
                +(1-5/ST)*demean_irf_star_full_5a(:,ss+1,b)'*demean_irf_star_full_5b(:,ss+1,bprime)...
                +(1-6/ST)*demean_irf_star_full_6a(:,ss+1,b)'*demean_irf_star_full_6b(:,ss+1,bprime)))/N;
            end
            Cf(b, bprime) = Cbb_f;
            Cf_opt(b, bprime) = Cbb_f_opt;
        end
    end
    
[Beta_f lambda_f] = eig(Cf);
% % lambda_f = diag(lambda_f);
% % correction = abs(lambda_f)<10^(-11);
% % lambda_f(correction)=0;
% % eigenvectors = Beta_f;
% % eigenvectors(:,correction)=0;
% I=eye(N); 
% adjustv=zeros(N,1);
% adjustv(N)=1;
% % if sum(lambda_f<0)>0
%     [UU, S, VV] = svd(Cf);
%     lambda_f = diag(S);
%     eigenvectors=zeros(N,N);
%     for i = 1:length(lambda_f);
%         shiftedM = Cf-lambda_f(i)*I;
%         rrefv = rref(shiftedM);
%         eigv = -rrefv(:,N)+adjustv;
%         eigv = eigv/norm(eigv);
%         eigenvectors(:,i) = eigv;
%     end
% % end
% lambda_f=diag(lambda_f);
% Beta_f=eigenvectors;
        
[Beta_f_opt lambda_f_opt] = eig(Cf_opt);
% % lambda_f_opt = diag(lambda_f_opt);
% % correction = abs(lambda_f_opt)<10^(-11);
% % lambda_f_opt(correction)=0;
% % eigenvectors = Beta_f_opt;
% % eigenvectors(:,correction)=0;
% % % I=eye(N); 
% % % adjustv=zeros(N,1);
% % % adjustv(N)=1;
% % if sum(lambda_f_opt<0)>0
%     [UU, S, VV] = svd(Cf_opt);
%     lambda_f_opt = diag(S);
%     eigenvectors=zeros(N,N);
%     for i = 1:length(lambda_f_opt);
%         shiftedM = Cf_opt-lambda_f_opt(i)*I;
%         rrefv = rref(shiftedM);
%         eigv = -rrefv(:,N)+adjustv;
%         eigv = eigv/norm(eigv);
%         eigenvectors(:,i) = eigv;
%     end
% % end
% lambda_f_opt=diag(lambda_f_opt);
% Beta_f_opt=eigenvectors;
        
psi_f = v_irf_star_full((4*hs+1):4*(h+1), :) - mean_irf_star_full((4*hs+1):4*(h+1));
phi_f = psi_f * Beta_f/N;
phi_f = (phi_f'./sqrt(diag(phi_f' * phi_f)))';
phi_f(isnan(phi_f))=0;

psi_f_opt = demean_irf_star_full+2*((1-1/ST)*demean_irf_star_full_1a...
                +(1-2/ST)*demean_irf_star_full_2a...
                +(1-3/ST)*demean_irf_star_full_3a...
                +(1-4/ST)*demean_irf_star_full_4a...
                +(1-5/ST)*demean_irf_star_full_5a...
                +(1-6/ST)*demean_irf_star_full_6a);
psi_f_opt = reshape(psi_f_opt, 4*(h+1), N);
psi_f_opt = psi_f_opt((4*hs + 1):4*(h+1), :);
phi_f_opt = psi_f_opt * Beta_f_opt/N;
% normalize phi
phi_f_opt = (phi_f_opt'./sqrt(diag(phi_f_opt' * phi_f_opt)))';
phi_f_opt(isnan(phi_f_opt))=0;

dynare dgptest noclearall;
for m = 1:4
    set_param_value('alpha',pair1(m)); 
    [info, oo_, options_] = stoch_simul(M_, options_, oo_, var_list_);
    [sim_array]=get_simul_replications(M_,options_);
    y_sim=squeeze(sim_array(strmatch('y',M_.endo_names,'exact'),:,:));
    simdata_alpha = sim_array([1 2],1001:(1000+T), :);
              
    m_irf_path_f = zeros(4*(h+1), 10);
    count = 1;
    j = 1;
    while count < 11
        try
            simdata_path_full = simdata_alpha(:, :, j);
            [Apathf,SIGMApathf,Upathf,Vpathf] = olsvarc(simdata_path_full', p);
            [IRFr_full]=bootirf(Apathf,Uf,v_sampledata_full',Vpathf);
            irf_path_f = vec(IRFr_full);
            m_irf_path_f(:, count) = irf_path_f;
            count = count + 1;
        catch
            count = count;
        end
        j = j+1;
    end
    mean_irf_f = sum(m_irf_path_f, 2)/10; 
    pair1_irf(:, m) = mean_irf_f;
end
psiprime_1 = (pair1_irf((4*hs+1):4*(h+1),1)-pair1_irf((4*hs+1):4*(h+1),2))/(2*step);
psiprime_2 = (pair1_irf((4*hs+1):4*(h+1),3)-pair1_irf((4*hs+1):4*(h+1),4))/(2*step);

%reg_dis_full = dis_full(:, m);
normsqr_1 = (phi_f' * psiprime_1).^2; % T by 1 vector
V_thetahat_1 = (diag(lambda_f)./(diag(lambda_f).^2 + pick_reg_a_1))' * normsqr_1;
V_thetahat_2 = (1/diag(lambda_f)) * normsqr_1;
        
normsqr_opt_1 = (phi_f_opt' * psiprime_1).^2; % T by 1 vector
V_thetahat_opt_1 = (diag(lambda_f_opt)./(diag(lambda_f_opt).^2 + pick_reg_a_2))' * normsqr_opt_1;
V_thetahat_opt_2 = (1/diag(lambda_f_opt)) * normsqr_opt_1;

normsqr_2 = (phi_f' * psiprime_2).^2; % T by 1 vector
V_theta0_1 = (diag(lambda_f)./(diag(lambda_f).^2 + pick_reg_a_1))' * normsqr_2;
V_theta0_2 = (1/diag(lambda_f)) * normsqr_2;
        
normsqr_opt_2 = (phi_f_opt' * psiprime_2).^2; % T by 1 vector
V_theta0_opt_1 = (diag(lambda_f_opt)./(diag(lambda_f_opt).^2 + pick_reg_a_2))' * normsqr_opt_2;
V_theta0_opt_2 = (1/diag(lambda_f_opt)) * normsqr_opt_2;

save_V_thetahat_1(ii) = V_thetahat_1;
save_V_thetahat_2(ii) = V_thetahat_2;
save_V_thetahat_opt_1(ii) = V_thetahat_opt_1;
save_V_thetahat_opt_2(ii) = V_thetahat_opt_2;
save_V_theta0_1(ii) = V_theta0_1;
save_V_theta0_2(ii) = V_theta0_2;
save_V_theta0_opt_1(ii) = V_theta0_opt_1;
save_V_theta0_opt_2(ii) = V_theta0_opt_2;
end
save_V_theta0_opt_1=abs(save_V_theta0_opt_1);
save_V_thetahat_opt_1=abs(save_V_thetahat_opt_1);
V_thetahat_diag = mean(save_V_thetahat_1.^(-1))
V_thetahat_diag = mean(save_V_thetahat_2.^(-1))
V_thetahat_opt = mean(save_V_thetahat_opt_1.^(-1))
V_theta0_diag = mean(save_V_theta0_1.^(-1))
V_theta0_diag = mean(save_V_theta0_2.^(-1))
V_theta0_opt = mean(save_V_theta0_opt_1.^(-1))


save V_T464sample10_full_nocontrol_1000 save_V_thetahat_1 save_V_thetahat_2... 
save_V_thetahat_opt_1 save_V_thetahat_opt_2...
save_V_theta0_1 save_V_theta0_2...
save_V_theta0_opt_1 save_V_theta0_opt_2